from distutils.core import setup, Extension
import sys
if sys.platform=='win32':
    socklibs=['wsock32']
else:
    socklibs=[]

ext = Extension('_socketrecvall',
                 sources = ['_socketrecvall.c'],
                 libraries = socklibs)

setup (name = 'socketrecvall',
    version = '1.0',
    author = 'Ines & Thilo Ernst',
    author_email = 'te0006@web.de',
    description = 'efficient recvall(), useful on platforms not supporting MSG_WAITALL',
    long_description = """Add-on for the builtin 'socket' as well as the 'timeoutsocket'
module. Implements an efficient recvall() function useful for
receiving large known-size chunks of data on platforms
not supporting the MSG_WAITALL flag (e.g. Win32)""",
    url = 'http://www.it-ernst.de/python',
    license = 'Python License',
    platforms = ['win32', 'linux'],
    py_modules=['socketrecvall'],
    ext_modules = [ext]
)
