/* _socketrecvall Python extension module  V1.0 (C) 2003 Ines & Thilo  Ernst   */


static char* DOC=\
"Extension for synchronously receiving a large (known-length)\n\
block of data from a connected TCP socket";

#include "Python.h"

#ifdef MS_WINDOWS
#include <winsock.h>
#define SOCKET_T SOCKET
#else

#include <sys/socket.h>
#include <netinet/in.h>
typedef int SOCKET_T;
#define SOCKET_ERROR -1

#endif

/*  BEGIN CUT&PASTE */
/*  from Python's  socketmodule.c - this is not exposed  in a header file */
typedef struct {
	PyObject_HEAD
	SOCKET_T sock_fd;	/* Socket file descriptor */
/* we could as well stop here as all we need is the offset for  sock_fd but this seemed a tad _too_ dirty */ 
	int sock_family;	/* Address family, e.g., AF_INET */
	int sock_type;		/* Socket type, e.g., SOCK_STREAM */
	int sock_proto;		/* Protocol type, usually 0 */
	union sock_addr {
		struct sockaddr_in in;
#ifdef ENABLE_IPV6
		struct sockaddr_in6 in6;
		struct sockaddr_storage storage;
#endif
#ifdef HAVE_NETPACKET_PACKET_H
		struct sockaddr_ll ll;
#endif
	} sock_addr;
} PySocketSockObject;
/*  END CUT&PASTE */


static int num_cycles; /* counter for low-level recv() cycles */

/* _recvall(connectedsocket, len ->string) */
PyObject* 
_recvall(PyObject *pSelf, PyObject *pArgs) {

    PySocketSockObject* pysocket;   /*  socketmodule.c's socket object (=arg1) */
    int total_size;	            /*  #bytes to receive in total (=arg2) */

    SOCKET_T socketHandle;          /*  OS representation of socket */
    PyObject* Buffer_PyString;      /*  result buffer (allocated here) */
    char* Buffer;                   /*  pointer to start of raw buffer area inside  Buffer_PyString */
    char* p_Buffer;                 /*  cursor pointing into raw buffer area */
    int bytes_get;                  /*  # bytes still to get */
    int bytes_got;                  /*  # bytes already got */

    int socketResult;

    if(PyTuple_Size(pArgs) != 2) { 
            PyErr_SetString(PyExc_SyntaxError, "recvall() takes 2 parameters");
            return NULL;
    }
    
    if ( !PyArg_ParseTuple(pArgs,"Oi",&pysocket, &total_size) ) {
            PyErr_SetString(PyExc_TypeError,"illegal argument, expected: (<socket>, int)");
            return NULL;
    }

    socketHandle = pysocket->sock_fd;
    
    Buffer_PyString = PyString_FromStringAndSize(NULL,total_size); /*  allocate uninitialized string of given length */
    
    if (!Buffer_PyString) {
        PyErr_SetString(PyExc_MemoryError,"cannot allocate result buffer");
        return NULL;
    }
    
    Buffer = PyString_AS_STRING(Buffer_PyString);

    num_cycles = 0;
    bytes_got = 0;
    socketResult = 1; /*  for while() below */
    p_Buffer = Buffer;

    Py_BEGIN_ALLOW_THREADS /*  no other thread can possibly have a reference to our string buffer object so we can safely release the GIL  */

    while ( (bytes_got<total_size) && (socketResult > 0) ) {
            /* One or two additions  could be optimized away here but hey, it's readable. */
            bytes_get     = total_size - bytes_got;	
            socketResult  = recv(socketHandle, p_Buffer, bytes_get, 0);
            p_Buffer     += socketResult;
            bytes_got    += socketResult;
            num_cycles++;
    }

    Py_END_ALLOW_THREADS
    
  
    if (socketResult == SOCKET_ERROR) {  /*  this happens when the connection breaks amidst a transfer */
        PyErr_SetString(PyExc_IOError, "Socket Error");
        PyMem_Free(Buffer_PyString);
        return NULL;
    }
        
    return(Buffer_PyString);
  
}

PyObject* 
_recvall_cycles(PyObject *pSelf, PyObject *pArgs) {
    if(PyTuple_Size(pArgs) != 0) { 
            PyErr_SetString(PyExc_SyntaxError, "recvall_getcycles() takes no arguments");
            return NULL;
    }
    return Py_BuildValue("i", num_cycles);
}

/*  _socketrecvall  method table */
static PyMethodDef modMethods[] = {
	{"recvall",            _recvall,              METH_VARARGS, 
         "recvall(<socket>, total_size) -> string : receive a large known-size TCP socket transmission in one go"},
	{"recvall_cycles",     _recvall_cycles,       METH_VARARGS, 
         "recvall_cycles() -> int: get last recvall()'s number of internal recv() cycles"},
	{NULL, NULL, 0, NULL}
};


/*  _socketrecvall module initialization */
#ifdef MS_WINDOWS
    __declspec(dllexport)
#endif

void init_socketrecvall(void) {
	Py_InitModule3("_socketrecvall", modMethods, DOC);
}
